/*=============================================================================}
{ This demo shows how to add controls to RichView                              }
{=============================================================================*/
//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma link "RichView"
#pragma link "RVScroll"
#pragma link "RVStyle"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::DoOnScrollBarChange(TObject* Sender)
{
  Label3->Caption = IntToStr(((TScrollBar*)Sender)->Position);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  RichView1->Clear();
  RichView1->AddNLATag("Example of adding controls", 1, 1, 0);

  // Adding "break" - horizontal line
  RichView1->AddBreakEx(3, rvbsLine, clRed);
  // 1st parameter - line width (AddBreak method adds break with width=1)
  // 2nd parameter - reserved, must be set to rvbsLine
  // 3rd parameter - color; if set to clNone, "break" will have color of the
  // 0th text style (AddBreak method adds break with color=clNone)

  //-------------------------------------------//
  //    Example 1: adding controls from form:  //
  //-------------------------------------------//
  // Adding combobox
  RichView1->AddNLATag("Combobox:", 0, 0, 0);
  // AddControlEx removes control from its current parent and insert into RichView
  // Just one line of code:
  RichView1->AddControlEx("", ComboBox1, 1, rvvaBaseline);

  //-------------------------------------------//
  //    Example 1: adding controls created at  //
  //    run-time:                              //
  //-------------------------------------------//
  RichView1->AddNLATag("Panel with scrollbar:", 0, 1, 0);
  // Adding panel with scrollbar
  TPanel * pan = new TPanel((TComponent*)NULL); // we can set NULL to Owner because this panel will be freed by RichView
  pan->Caption = "";
  pan->Width   = 100;
  pan->Height  = 60;
  TScrollBar* sb = new TScrollBar(pan); // panel will free scrollbar
  sb->Parent   = pan;
  sb->Min      = -10;
  sb->Max      = 10;
  sb->SetBounds(10,20,80,20);
  sb->OnChange = DoOnScrollBarChange;
  RichView1->AddControlEx("", pan, -1, rvvaMiddle);

  RichView1->AddBreakEx(3, rvbsLine, clRed);

  RichView1->Format();

  // About AddControlEx:
  // Parameters of this method are similar with parameters of AddPictureEx:
  // 1st parameter: name of control. Allows to hold additional text information
  //  together with control. There is no predefined meaning of this
  //  parameter.
  // 2nd parameter: control
  // 3rd parameter: index of paragraph style (-1 to continue paragraph)
  // 4th parameter: vertical align of control.
}
//---------------------------------------------------------------------------
